<?php
class TermoAutorizacao {
    private $dados;

    public function __construct($dados) {
        $this->dados = $dados;
    }

    public function gerarXML() {
        $xml = new SimpleXMLElement("<?xml version='1.0' encoding='UTF-8'?><termoDeAutorizacao></termoDeAutorizacao>");
        $dados = $xml->addChild('dados');

        $sistema = $dados->addChild('sistema');
        $sistema->addAttribute('id', 'API Integra Contador');

        $termo = $dados->addChild('termo');
        $termo->addAttribute('texto', 'Autorizo a empresa CONTRATANTE, identificada neste termo de autorização como DESTINATÁRIO, a executar as requisições dos serviços web disponibilizados pela API INTEGRA CONTADOR, onde terei o papel de AUTOR PEDIDO DE DADOS no corpo da mensagem enviada na requisição do serviço web. Esse termo de autorização está assinado digitalmente com o certificado digital do PROCURADOR ou OUTORGADO DO CONTRIBUINTE responsável, identificado como AUTOR DO PEDIDO DE DADOS.');

        $avisoLegal = $dados->addChild('avisoLegal');
        $avisoLegal->addAttribute('texto', 'O acesso a estas informações foi autorizado pelo próprio PROCURADOR ou OUTORGADO DO CONTRIBUINTE, responsável pela informação, via assinatura digital. É dever do destinatário da autorização e consumidor deste acesso observar a adoção de base legal para o tratamento dos dados recebidos conforme artigos 7º ou 11º da LGPD (Lei n.º 13.709, de 14 de agosto de 2018), aos direitos do titular dos dados (art. 9º, 17 e 18, da LGPD) e aos princípios que norteiam todos os tratamentos de dados no Brasil (art. 6º, da LGPD).');

        $finalidade = $dados->addChild('finalidade');
        $finalidade->addAttribute('texto', 'A finalidade única e exclusiva desse TERMO DE AUTORIZAÇÃO, é garantir que o CONTRATANTE apresente a API INTEGRA CONTADOR esse consentimento do PROCURADOR ou OUTORGADO DO CONTRIBUINTE assinado digitalmente, para que possa realizar as requisições dos serviços web da API INTEGRA CONTADOR em nome do AUTOR PEDIDO DE DADOS (PROCURADOR ou OUTORGADO DO CONTRIBUINTE).');

        $dados->addChild('dataAssinatura')->addAttribute('data', date("Ymd"));
        $dados->addChild('vigencia')->addAttribute('data', date('Ymd', strtotime("+30 days")));

        $destinatario = $dados->addChild('destinatario');
        foreach ($this->dados['destinatario'] as $key => $value) {
            $destinatario->addAttribute($key, $value);
        }

        $assinadoPor = $dados->addChild('assinadoPor');
        foreach ($this->dados['assinante'] as $key => $value) {
            $assinadoPor->addAttribute($key, $value);
        }

        return $xml->asXML();
    }
}